/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class PhotonDisplay
extends JPanel
implements Updatee {
    private Color color;
    private BufferedImage offScreen;
    private int numPixelsPerFrame;
    private int wavelength;
    private boolean leftSlitIsOpen;
    private boolean rightSlitIsOpen;
    private PhotonProbability photonProbability;
    private final int tableLength = 350;

    public PhotonDisplay() {
        this.setPreferredSize(new Dimension(700, 100));
        this.setBackground(Color.white);
        this.numPixelsPerFrame = 1;
        this.leftSlitIsOpen = true;
        this.rightSlitIsOpen = false;
        this.wavelength = 380;
        this.photonProbability = new PhotonProbability(350, this.wavelength);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setWavelength(int n) {
        this.color = WavelengthToColor.convert(n);
        this.wavelength = n;
        this.photonProbability.setWavelength(n);
    }

    public void setNumPixelsPerFrame(int n) {
        this.numPixelsPerFrame = n;
    }

    public void setLeftSlitOpen(boolean bl) {
        this.leftSlitIsOpen = bl;
    }

    public void setRightSlitOpen(boolean bl) {
        this.rightSlitIsOpen = bl;
    }

    public synchronized void threadUpdate() {
        Graphics2D graphics2D;
        Dimension dimension = this.getSize();
        Graphics graphics = this.getGraphics();
        if (!this.leftSlitIsOpen && !this.rightSlitIsOpen) {
            return;
        }
        if (this.offScreen == null) {
            this.offScreen = new BufferedImage(dimension.width, dimension.height, 1);
            graphics2D = this.offScreen.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics2D = this.offScreen.createGraphics();
        }
        graphics.setColor(this.color);
        graphics2D.setColor(this.color);
        int n = 0;
        while (n < this.numPixelsPerFrame) {
            int n2 = dimension.width / 2;
            int n3 = this.leftSlitIsOpen && !this.rightSlitIsOpen ? this.photonProbability.oneSlitDisplacement() : (!this.leftSlitIsOpen && this.rightSlitIsOpen ? this.photonProbability.oneSlitDisplacement() : this.photonProbability.twoSlitDisplacement());
            n2 = Math.random() > 0.5 ? (n2 -= n3) : (n2 += n3);
            int n4 = (int)(Math.random() * (double)dimension.height);
            graphics2D.drawLine(n2, n4, n2, n4);
            graphics.drawLine(n2, n4, n2, n4);
            ++n;
        }
        graphics.dispose();
        graphics2D.dispose();
    }

    public synchronized void reset() {
        this.offScreen = new BufferedImage(this.getSize().width, this.getSize().height, 1);
        Graphics2D graphics2D = this.offScreen.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        Graphics graphics = this.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.dispose();
        graphics2D.dispose();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (this.offScreen == null || this.offScreen.getWidth() != dimension.width || this.offScreen.getHeight() != dimension.height) {
            this.offScreen = new BufferedImage(dimension.width, dimension.height, 1);
            Graphics2D graphics2D = this.offScreen.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.dispose();
        }
        graphics.drawImage(this.offScreen, 0, 0, this);
    }
}

