/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhotonPanel
extends JPanel {
    private final JButton resetButton;
    private final JButton pauseButton;
    private final JButton startButton;
    private final JButton spawnButton;
    private final JPanel controlPanel;
    private final JPanel optionsPanel;
    private final JPanel buttonsPanel;
    private final JPanel wavelengthPanel;
    private final JPanel checkPanel;
    private final JPanel colorPreviewPanel;
    private final JPanel speedPanel;
    private final JCheckBox leftCheck;
    private final JCheckBox rightCheck;
    private final JLabel wavelengthLabel;
    private final JLabel speedLabel;
    private final JSlider wavelengthSlider;
    private final JSlider speedSlider;
    private final PhotonDisplay photonDisplay;
    private final UpdateThread updateThread;
    private final int DEFAULT_SPEED = 20;
    private boolean isPaused;
    private static int openPanels = 0;
    private static int closedPanels = 0;

    public PhotonPanel() {
        ++openPanels;
        this.isPaused = false;
        this.photonDisplay = new PhotonDisplay();
        this.updateThread = new UpdateThread(this.photonDisplay);
        this.resetButton = new JButton("Reset");
        this.pauseButton = new JButton("Pause");
        this.startButton = new JButton("Start");
        this.spawnButton = new JButton("Spawn another window");
        this.controlPanel = new JPanel();
        this.controlPanel.add(this.resetButton);
        this.controlPanel.add(this.pauseButton);
        this.controlPanel.add(this.startButton);
        this.controlPanel.add(this.spawnButton);
        this.leftCheck = new JCheckBox("Left");
        this.rightCheck = new JCheckBox("Right");
        this.checkPanel = new JPanel();
        this.checkPanel.setBorder(BorderFactory.createTitledBorder("Open Slits"));
        this.checkPanel.add(this.leftCheck);
        this.checkPanel.add(this.rightCheck);
        this.wavelengthSlider = new JSlider(380, 780, 380);
        this.wavelengthLabel = new JLabel("380");
        this.wavelengthPanel = new JPanel();
        this.colorPreviewPanel = new JPanel();
        this.colorPreviewPanel.setPreferredSize(new Dimension(30, 30));
        this.wavelengthPanel.setBorder(BorderFactory.createTitledBorder("Wavelength( \u03bb )"));
        this.wavelengthPanel.add(this.colorPreviewPanel);
        this.wavelengthPanel.add(this.wavelengthSlider);
        this.wavelengthPanel.add(this.wavelengthLabel);
        this.speedSlider = new JSlider(1, 100, 20);
        this.photonDisplay.setNumPixelsPerFrame(20);
        this.speedLabel = new JLabel("20");
        this.speedLabel.setPreferredSize(new Dimension(30, 30));
        this.speedPanel = new JPanel();
        this.speedPanel.setBorder(BorderFactory.createTitledBorder("Speed"));
        this.speedPanel.add(this.speedSlider);
        this.speedPanel.add(this.speedLabel);
        this.optionsPanel = new JPanel();
        this.optionsPanel.add(this.checkPanel);
        this.optionsPanel.add(this.wavelengthPanel);
        this.optionsPanel.add(this.speedPanel);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BorderLayout());
        this.buttonsPanel.add((Component)this.optionsPanel, "First");
        this.buttonsPanel.add((Component)this.controlPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonsPanel, "Last");
        this.add((Component)this.photonDisplay, "Center");
        this.resetButton.addActionListener(new ResetListener());
        this.pauseButton.addActionListener(new PauseListener());
        this.startButton.addActionListener(new StartListener());
        this.spawnButton.addActionListener(new SpawnListener());
        this.leftCheck.addActionListener(new CheckboxListener());
        this.rightCheck.addActionListener(new CheckboxListener());
        this.wavelengthSlider.addChangeListener(new WavelengthListener());
        this.speedSlider.addChangeListener(new SpeedListener());
        this.pauseButton.setEnabled(false);
        this.leftCheck.setSelected(true);
        this.rightCheck.setSelected(true);
        this.photonDisplay.setLeftSlitOpen(true);
        this.photonDisplay.setRightSlitOpen(true);
        this.updateColorPreview();
        this.updateThread.start();
    }

    private void updateColorPreview() {
        int n = this.wavelengthSlider.getValue();
        Color color = WavelengthToColor.convert(n);
        this.colorPreviewPanel.setBackground(color);
        this.wavelengthLabel.setText(Integer.toString(n));
        this.photonDisplay.setWavelength(n);
    }

    private void setPaused(boolean bl) {
        this.isPaused = bl;
        if (this.isPaused) {
            this.pauseButton.setText("Unpause");
        } else {
            this.pauseButton.setText("Pause");
        }
        this.updateThread.setPause(this.isPaused);
    }

    public static void openNewFrame() {
        JFrame jFrame = new JFrame("Photon Experiment Window " + (openPanels + 1));
        jFrame.add(new PhotonPanel());
        jFrame.addWindowListener(new GenericWindowListener());
        jFrame.pack();
        jFrame.setLocation((1 + openPanels) * 10, (1 + openPanels) * 10);
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        PhotonPanel.openNewFrame();
    }

    private static class GenericWindowListener
    extends WindowAdapter {
        private GenericWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            closedPanels++;
            if (openPanels == closedPanels) {
                System.exit(0);
            }
        }
    }

    private class CheckboxListener
    implements ActionListener {
        private CheckboxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PhotonPanel.this.photonDisplay.setLeftSlitOpen(PhotonPanel.this.leftCheck.isSelected());
            PhotonPanel.this.photonDisplay.setRightSlitOpen(PhotonPanel.this.rightCheck.isSelected());
        }
    }

    private class StartListener
    implements ActionListener {
        private StartListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PhotonPanel.this.setPaused(false);
            PhotonPanel.this.pauseButton.setEnabled(true);
            PhotonPanel.this.startButton.setEnabled(false);
        }
    }

    private class PauseListener
    implements ActionListener {
        private PauseListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PhotonPanel.this.isPaused = !PhotonPanel.this.isPaused;
            PhotonPanel.this.setPaused(PhotonPanel.this.isPaused);
        }
    }

    private class ResetListener
    implements ActionListener {
        private ResetListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PhotonPanel.this.updateThread.setPause(true);
            PhotonPanel.this.photonDisplay.reset();
            PhotonPanel.this.pauseButton.setText("Pause");
            PhotonPanel.this.isPaused = false;
            PhotonPanel.this.pauseButton.setEnabled(false);
            PhotonPanel.this.startButton.setEnabled(true);
        }
    }

    private class SpeedListener
    implements ChangeListener {
        private SpeedListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = PhotonPanel.this.speedSlider.getValue();
            PhotonPanel.this.photonDisplay.setNumPixelsPerFrame(n);
            PhotonPanel.this.speedLabel.setText(Integer.toString(n));
        }
    }

    private class WavelengthListener
    implements ChangeListener {
        private WavelengthListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            PhotonPanel.this.updateColorPreview();
        }
    }

    private class SpawnListener
    implements ActionListener {
        private SpawnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PhotonPanel.openNewFrame();
        }
    }
}

