/*
 * Decompiled with CFR 0.152.
 */
public class PhotonProbability {
    private double[] oneSlit;
    private double[] twoSlit;
    private int length;

    public PhotonProbability(int n, int n2) {
        this.length = n;
        this.fillOneSlit(n2);
        this.fillTwoSlit(n2);
    }

    public synchronized void setWavelength(int n) {
        this.fillOneSlit(n);
        this.fillTwoSlit(n);
    }

    private void fillTwoSlit(int n) {
        if (this.twoSlit == null) {
            this.twoSlit = new double[this.length];
        }
        this.twoSlit[0] = 1.5059821168654416E-4;
        int n2 = 1;
        while (n2 < this.length) {
            double d = (double)n2 * Math.PI / (double)(this.length * n / 580);
            this.twoSlit[n2] = this.twoSlit[n2 - 1] + Math.pow(Math.sin(d), 2.0) * Math.pow(Math.cos(d * 4.0), 2.0) / Math.pow(n2, 2.0);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.length) {
            this.twoSlit[n3] = this.twoSlit[n3] / this.twoSlit[this.length - 1];
            ++n3;
        }
    }

    private void fillOneSlit(int n) {
        if (this.oneSlit == null) {
            this.oneSlit = new double[this.length];
        }
        this.oneSlit[0] = 1.5059821168654416E-4;
        int n2 = 1;
        while (n2 < this.length) {
            this.oneSlit[n2] = this.oneSlit[n2 - 1] + Math.pow(Math.sin((double)n2 * Math.PI / (double)this.length), 2.0) / Math.pow(n2, 2.0);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.length) {
            this.oneSlit[n3] = this.oneSlit[n3] / this.oneSlit[this.length - 1];
            ++n3;
        }
    }

    public synchronized int twoSlitDisplacement() {
        return this.searchArray(this.twoSlit, Math.random());
    }

    public synchronized int oneSlitDisplacement() {
        return this.searchArray(this.oneSlit, Math.random());
    }

    private int searchArray(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length && d > dArray[n]) {
            ++n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        int n = 380;
        PhotonProbability photonProbability = new PhotonProbability(350, n);
        int n2 = 0;
        while (n2 < photonProbability.oneSlit.length) {
            System.out.println("oneSlit[" + n2 + "] = " + photonProbability.oneSlit[n2]);
            ++n2;
        }
        System.out.println();
        int n3 = 0;
        while (n3 < photonProbability.twoSlit.length) {
            System.out.println("twoSlit[" + n3 + "] = " + photonProbability.twoSlit[n3]);
            ++n3;
        }
    }
}

